/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.project.ellareader.bean;

import androidx.annotation.NonNull;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import java.util.Objects;

@Entity(tableName="read_record", primaryKeys={"uid", "bookCode", "pageNum", "totalPage", "readModel", "readStart", "endTime"})
public class ReadRecord {
    @NonNull
    @ColumnInfo(name="uid")
    public String uid;
    @NonNull
    @ColumnInfo(name="bookCode")
    public String bookCode;
    @NonNull
    @ColumnInfo(name="pageNum")
    public int pageNum;
    @NonNull
    @ColumnInfo(name="totalPage")
    public int totalPage;
    @NonNull
    @ColumnInfo(name="readModel")
    public String readModel;
    @NonNull
    @ColumnInfo(name="readStart")
    public long readStart;
    @NonNull
    @ColumnInfo(name="endTime")
    public long endTime;

    public static ReadRecord build(String bookCode, int pageNum, int totalPage, long readStart, long endTime, String uid) {
        ReadRecord readRecord = new ReadRecord();
        readRecord.bookCode = bookCode;
        readRecord.pageNum = pageNum;
        readRecord.totalPage = totalPage;
        readRecord.readModel = "READ";
        readRecord.readStart = readStart;
        readRecord.endTime = endTime;
        readRecord.uid = uid;
        return readRecord;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadRecord that = (ReadRecord)o;
        return this.pageNum == that.pageNum && this.totalPage == that.totalPage && this.readStart == that.readStart && this.endTime == that.endTime && Objects.equals(this.uid, that.uid) && Objects.equals(this.bookCode, that.bookCode) && Objects.equals(this.readModel, that.readModel);
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.bookCode, this.pageNum, this.totalPage, this.readModel, this.readStart, this.endTime);
    }
}

