/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.project.ellareader;

import android.app.Activity;
import com.ellabook.project.ellareader.IReaderController;
import com.ellabook.project.ellareader.TryReadController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ReaderModule
implements IReaderController {
    private static boolean sDebugable = false;
    static boolean sAddWordEnable = true;
    static boolean sShowCopyRight = true;
    private List<IReaderController> mReaderControllers = new ArrayList<IReaderController>();
    private static TryReadController tryReadController;

    public static TryReadController getTryReadController() {
        return tryReadController;
    }

    public static void setTryReadController(TryReadController _tryReadController) {
        tryReadController = _tryReadController;
    }

    public static boolean showCopyRight() {
        return sShowCopyRight;
    }

    public static void setShowCopyRight(boolean sShowCopyRight) {
        ReaderModule.sShowCopyRight = sShowCopyRight;
    }

    public static boolean isAddWordEnable() {
        return sAddWordEnable;
    }

    public static boolean isDebugable() {
        return sDebugable;
    }

    public static void init(boolean addWordEnable, boolean debugable) {
        sAddWordEnable = addWordEnable;
        sDebugable = debugable;
    }

    public static IReaderController getReaderController() {
        return HOLDER.sReaderModule;
    }

    public static void add(IReaderController controller) {
        HOLDER.sReaderModule.mReaderControllers.add(controller);
    }

    @Override
    public void onBookReadPassed(String bookCode, String bookType, long missionId, long mapId, String bookCover, HashMap<Integer, Integer> questionQuantity, Activity activity, int requestCode, ArrayList<String> readStartEnds, int power, IReaderController.AnalysisFinishCallback callback) {
        for (IReaderController controller : this.mReaderControllers) {
            controller.onBookReadPassed(bookCode, bookType, missionId, mapId, bookCover, questionQuantity, activity, requestCode, readStartEnds, power, callback);
        }
    }

    @Override
    public void postBookPassed(String bookCode, String bookType, long missionId) {
        for (IReaderController controller : this.mReaderControllers) {
            controller.postBookPassed(bookCode, bookType, missionId);
        }
    }

    @Override
    public boolean canDoneWith(String bookCode, String bookType, byte mode) {
        for (IReaderController controller : this.mReaderControllers) {
            if (!controller.canDoneWith(bookCode, bookType, mode)) continue;
            return true;
        }
        return false;
    }

    private static class HOLDER {
        private static final ReaderModule sReaderModule = new ReaderModule();

        private HOLDER() {
        }
    }
}

