package com.ella.user.dto.user;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.NotEmpty;

import java.io.Serializable;

/**
 * @author ZLN
 * @create 2018-07-24 19:09
 **/
@ApiModel("修改密码校验验证码入参")
@Data
public class CheckCodeConfirmRequest implements Serializable {
    private static final long serialVersionUID = 791893472422058217L;
    @ApiModelProperty(notes = "手机号",required = true)
    @NotBlank(message = "手机号为空")
    private String customerName;

    @ApiModelProperty(notes = "验证码",required = true)
    @NotBlank(message = "验证码不能为空")
    private String checkCode;

    public CheckCodeConfirmRequest(String customerName, String checkCode) {
        this.customerName = customerName;
        this.checkCode = checkCode;
    }

    public CheckCodeConfirmRequest() {
    }
}

