package com.ella.user.dto.request.userinfo;

import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("更新用户等级和蓝思值请求")
public class UpdateUserLevelRequest {

	@NotNull
	@ApiModelProperty(value = "用户UID", required = true)
	private String uid;

	@NotNull
	@ApiModelProperty(value = "等级编码", required = true)
	private String levelCode;

	@NotNull
	@ApiModelProperty(value = "蓝思能力值", required = true)
	private String lexileLevel;
}
