package com.ella.user.dto.request.userinfo;

import com.ella.user.dto.PageDto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("查询用户列表请求")
public class ListUserInfoRequest extends PageDto {

	private static final long serialVersionUID = -8938647678403273216L;

	@ApiModelProperty(value = "搜索关键字（精确匹配UID或手机号）", required = false)
	private String searchKey;

	@ApiModelProperty(value = "排序（1：注册时间顺序，2：注册时间倒序，3：最后登录时间顺序，4：最后登录时间倒序）", hidden = true)
	private Integer orderBy = 1;
}
