package com.ella.user.dto.request.dictionary;

import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("用户查词入参")
public class QueryWordRequest {
	
	@ApiModelProperty(notes="查看的单词",required=true)
	@NotEmpty
	@Length(max = 200)
	private String word;
	
	@ApiModelProperty(notes="用户UID",required=false)
	@NotEmpty
	private String uid;

	@ApiModelProperty(notes="参数类型 0-单词 1-句子")
	private Integer type;

	@ApiModelProperty(notes="数据来源 0-书城 1-闯关 不传表示有道第三方")
	private Integer sourceType;

}
