package com.ella.user.dto.request.dictionary;

import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("用户课程查词入参")
public class QueryWordInCourseRequest {
	
	@ApiModelProperty(notes="查看的单词",required=true)
	@NotEmpty
	@Length(max = 200)
	private String word;
	
	@ApiModelProperty(notes="用户UID",required=false)
	@NotEmpty
	private String uid;
	
	
	@ApiModelProperty(notes="关卡编码",required=true)
	@NotEmpty
	private String missionCode;
	
	@ApiModelProperty(notes="课程编码",required=true)
	@NotEmpty
	private String courseCode;

}
