package com.ella.user.dto.account;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import org.hibernate.validator.constraints.NotEmpty;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("修改用户能量石数量")
public class ModifyUserStoneRequest implements Serializable{
	
	private static final long serialVersionUID = -7221659089365253987L;
	
	
	@ApiModelProperty(notes="用户uid",required=true)
	@NotEmpty
	private String uid;
	
	@ApiModelProperty(notes="能量石数量",required=true)
	@NotNull
	private Integer stoneNum;
	
	@ApiModelProperty(notes="收支标识 （+ 代表 收入 “-” -- 消费）",required=true)
	@NotNull
	private MoneyChangeTypeEnum opperType; 
	
	@ApiModelProperty(notes="收支类型 (PASS_MISSION-闯关成功,LEXILE_TEST-蓝思评测)",required=true)
	private EventTypeEnum eventType;
	
	@ApiModelProperty(notes="时间戳，防重复处理",required=true)
	@NotNull
	private Long timex;
	
	@ApiModelProperty(notes="关联id (如关联的关卡id，用户某次评测id)",required=true)
	@NotEmpty
	private String relationId;
	
	@ApiModelProperty(notes="描述",required=true)
	@NotNull
	private String description;
	
	

}
