package com.ella.user.dto.account;


/**
 * 账户类型
 * */
public enum AccountTypeEnum {
	/**
	 * 账户类型-IOS账户
	 */
	IOS_ACCOUNT("IOS_ACCOUNT", "IOS账户"),
	NORMAL_ACCOUNT("NORMAL_ACCOUNT", "通用账户"),
	STONE_ACCOUNT("STONE_ACCOUNT","能量石账户")
    ;
	private final String code;

	private final String msg;


	AccountTypeEnum(String code, String msg) {
		this.code = code;
		this.msg = msg;
	}

	
	public String msg() {
		return this.msg;
	}

	 public static AccountTypeEnum getEnumByCode(String code) {
	        for (AccountTypeEnum retCodeEnum : AccountTypeEnum.values()) {
	            if (retCodeEnum.code == code) {
	                return retCodeEnum;
	            }
	        }
	        return null;
	    }


	public String getCode() {
		return code;
	}


	public String getMsg() {
		return msg;
	}
}
