package com.ella.user.dto;

import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("用户评论详情")
public class UserReviewDto implements Serializable {
	private static final long serialVersionUID = 8538656816620733746L;

	@ApiModelProperty(value = "评论ID", required = false)
	private Long id;

	@ApiModelProperty(value = "用户UID", required = false)
	private String userId;

	@ApiModelProperty(value = "用户账号", required = false)
	private String userMobile;

	@ApiModelProperty(value = "用户昵称", required = false)
	private String userName;

	@ApiModelProperty(value = "资源ID", required = false)
	private String resId;

	@ApiModelProperty(value = "资源类型（BOOK-绘本）", required = false)
	private String resType;

	@ApiModelProperty(value = "资源名称", required = false)
	private String resName;

	@ApiModelProperty(value = "评论类型（TEXT-文本,VOICE-语音）", required = false)
	private String reviewType;

	@ApiModelProperty(value = "评论星级(0-5)", required = false)
	private Short reviewLevel;

	@ApiModelProperty(value = "评论内容", required = false)
	private String reviewContent;

	@ApiModelProperty(value = "是否精彩评论(N-否，Y-是)", required = false)
	private String isPerfect;

	@ApiModelProperty(value = "评论审批状态 (WAIT_APPROVAL-未审批，APPROVAL_YES-审批通过，APPROVAL_NO-审批拒绝)", required = false)
	private String approvalStatus;

	@ApiModelProperty(value = "创建人", required = false)
	private String createBy;

	@ApiModelProperty(value = "修改人", required = false)
	private String updateBy;

	@ApiModelProperty(value = "数据状态(NORMAL-正常,DELETE-删除)", required = false)
	private String status;

	@ApiModelProperty(value = "评论时间", required = false)
	private Date reviewTime;

	@ApiModelProperty(value = "创建时间", required = false)
	private Date createTime;

	@ApiModelProperty(value = "更新时间", required = false)
	private Date updateTime;

}
