package com.ella.user.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;

@Data
@ApiModel("用户信息")
@EqualsAndHashCode
public class UserInfoDto implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(notes = "用户主键ID")
    private Integer id;

    @ApiModelProperty(notes = "头像")
    private String avatar;

    @ApiModelProperty(notes = "英文名称")
    private String enName;

    @ApiModelProperty(notes = "性别")
    private String gender;

    @ApiModelProperty(notes = "生日")
    private Date birthday;

    @ApiModelProperty(notes = "地区")
    private String region;

    @ApiModelProperty(notes = "用户编号")
    private String uid;

    @ApiModelProperty(notes = "电话")
    private String mobile;

    @ApiModelProperty(notes = "姓名")
    private String name;

    @ApiModelProperty(notes = "年龄")
    private Integer age;

    @ApiModelProperty(notes = "阅读/指导等级")
    private String level;

    @ApiModelProperty(notes = "蓝思等级")
    private String lexileLevel;

    @ApiModelProperty(notes = "状态")
    private String status;

    @ApiModelProperty(notes = "余额")
    private String balance;

    @ApiModelProperty(notes = "是否游客 Y 是")
    private String isVisitor;

    @ApiModelProperty(notes = "账户信息")
    private AccountDto accountDto;

    @ApiModelProperty(notes = "账号绑定信息")
    private Map<String, Long> bindInfo;

    @ApiModelProperty(notes = "是否闯关会员 Y-是 N-否")
    private String isVip;

    @ApiModelProperty(notes = "会员开始时间")
    private Date vipBegin;

    @ApiModelProperty(notes = "会员结束时间")
    private Date vipEnd;

    @ApiModelProperty(notes = "是否闯关新用户")
    private Boolean newMapUser;

    private Integer stoneNum = 0;

    private Integer evaluationTime;
}
