package com.ella.user.dto;

import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("用户反馈信息详情")
public class UserFeedbackDto {

	@ApiModelProperty("反馈ID")
	private Long id;

	@ApiModelProperty("用户ID")
	private String uid;

	@ApiModelProperty("用户名")
	private String uname;

	@ApiModelProperty("反馈内容")
	private String content;

	@ApiModelProperty("附图1")
	private String attach1;

	@ApiModelProperty("附图2")
	private String attach2;

	@ApiModelProperty("附图3")
	private String attach3;

	@ApiModelProperty("反馈渠道")
	private String channel;

	@ApiModelProperty("设备型号")
	private String deviceModel;

	@ApiModelProperty("版本号")
	private String version;

	@ApiModelProperty("联系方式")
	private String contact;

	@ApiModelProperty("处理状态(WAIT_APPROVAL-未处理,RECEIVED-已接收，CONNECTING-联系中，RESOLVED-已解决)")
	private String approvalStatus;

	@ApiModelProperty("创建时间")
	private Date createTime;

	@ApiModelProperty("更新人员ID")
	private String updateBy;

	@ApiModelProperty("更新时间")
	private Date updateTime;

	@ApiModelProperty("数据状态(NORMAL-正常,DELETE-删除)")
	private String status;

	@ApiModelProperty("反馈处理记录")
	private List<UserFeedbackHandleRecordDto> handleRecord;
}
