package com.ella.user.dto;

import java.io.Serializable;
import java.util.Date;

import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 编辑用户评论请求类
 * <p>
 * 用于设置/取消精彩评论，更新评论数据状态
 * </p>
 * 
 * @author maofengHan
 *
 */
@Data
@ApiModel("更新用户评论请求")
public class UpdateUserReviewRequest implements Serializable {

	private static final long serialVersionUID = 4191676271691898791L;

	@NotNull
	@ApiModelProperty(value = "评论ID", required = true)
	private Long id;

	@ApiModelProperty(value = "是否精彩评论(N-否，Y-是)", required = false)
	private String isPerfect;

	@ApiModelProperty(value = "评论审批状态 (WAIT_APPROVAL-未审批，APPROVAL_YES-审批通过，APPROVAL_NO-审批拒绝)", required = false)
	private String approvalStatus;

	@ApiModelProperty(value = "修改人", required = false)
	private String updateBy;

	@ApiModelProperty(value = "数据状态(NORMAL-正常,DELETE-删除)", required = false)
	private String status;

	@ApiModelProperty(value = "更新时间", required = false)
	private Date updateTime;
}
