package com.ella.user.dto;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import org.hibernate.validator.constraints.NotEmpty;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("更新产品信息入参")
public class UpdateProductRequest implements Serializable{
	
	private static final long serialVersionUID = 4632283139895831107L;
	
	@ApiModelProperty(notes="产品id",required=true)
	@NotNull
	private Long id;
	
	@ApiModelProperty(notes="产品（服务）名称",required=true)
	@NotEmpty(message="产品（服务）名称 不能为空")
    private String name;
	
	@ApiModelProperty(notes="学科（1:英语 2:语文 3:数学）,required=true")
	@NotNull
    private Long subjectType;
	
	@ApiModelProperty(notes="授课类型（1:1vs1 2:1vs2 3:1vs3 4:1vs4 10:大会堂）",required=true)
	@NotNull
    private Long teachingType;
	
	@ApiModelProperty(notes="课程时长（单位：分钟）",required=true)
	@NotNull
    private Long courseDuration;
	
	@ApiModelProperty(notes="课程间隙时长（单位：分钟）",required=true)
	@NotNull
	private Long intervalTime;
	
	@ApiModelProperty(notes="每堂最低警示价（人民币，单位：分）",required=true)
	@NotNull
	private Long perMinimumPrice;
	
	@ApiModelProperty(notes="可提前订课时间（单位：分）",required=true)
	@NotNull
	private Long advanceReserveTime;
	
	@ApiModelProperty(notes="可提前取消时间（单位：分）",required=true)
	@NotNull
    private Long advanceCancelTime;
	
	@ApiModelProperty(notes="可提前进教室时间（单位：分）",required=true)
	@NotNull
    private Long advanceEnterTime;
	
	@ApiModelProperty("产品（服务）描述")
    private String description; 

}
