package com.ella.user.dto;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("更新昵称配置请求参数")
public class UpdateNicknameCfgRequest implements Serializable {

	private static final long serialVersionUID = 4366572464863503361L;

	@ApiModelProperty(value = "英文昵称", required = true)
	@NotNull
	private String eName;

	@ApiModelProperty("中文昵称")
	private String cName;

	@ApiModelProperty("性别（男:MALE  女:FEMALE）")
	private String gender;

	@ApiModelProperty(value = "更新人", hidden = true)
	private String updateBy;

	@ApiModelProperty("当前状态(NORMAL-正常,DELETE-删除)")
	private String status;
}
