package com.ella.user.dto;


public enum RetCodeEnum {
    /**
     * 异常信息
     */
    CANNOT_EDIT_GOODS("401001", "无法修改商品信息"),
    GOODS_NOT_EXISTS("401002", "商品不存在"),
    CREATE_ORDER_ERROR("401003", "下单失败，请稍后再试"),
    USERNAME_NOT_FOUND("401004", "用户不存在"),
    USERNAME_PASSWORD_INVALID("401005", "用户名或密码错误"),
    USER_NOT_FOUNT("401006", "用户未注册"),
    SEND_SUCCESS("401007", "发送成功"),
    SEND_ERROR("401008", "错误"),
    LOGIN_ERROR("401009", "登录密码错误"),
    CHECK_CODE_LOSE("401010", "验证码错误或失效"),
    CHECK_CODE_ERROR("401011", "验证码错误或失效"),
    UPDATE_ERROR("401012", "修改失败"),
    ACCOUNT_ELLA_DEAL_REPEAT("401013", "咿啦币变动重复处理"),
    ACCOUNT_ELLA_CHANGE_MONEY_ERROR("401014", "用户账户咿啦币加减失败"),
    ACCOUNT_STONE_DEAL_REPEAT("401015", "能量石重复处理"),
    ACCOUNT_ELLA_BALANCE_NOT_ENOUGH("401016", "用户咿啦币余额不足"),
    ACCOUNT_ELLA_STONE_NOT_ENOUGH("401017", "用户能量石余额不足"),
    ACCOUNT_ELLA_CHANGE_STONE_ERROR("401018", "用户账户能量石加减失败"),
    BIND_IPHONENUM("401019", "绑定手机号"),
    BIND_INSERT_FAIL("401020", "第三方插入失败"),
    BIND_UID_FAIL("401021", "绑定账号失败"),
    UN_BIND_FAIL("401022", "解除绑定失败,该第三方不存在"),
    SMS_SUCCESS("401023", "验证码已发送"),
    SMS_BUSY("401024", "过于频繁，请10分钟后再次尝试"),
    PHONE_NOT_IN("401025", "手机号未注册"),
    PHONE_IN("401026", "手机号已注册"),
    PHONE_ALREADY_BIND("401027", "手机号已绑定,请更换手机号"),
    PHONE_NOT_REG("401028", "手机号未注册"),
    IS_BINDING("401029", "已绑定，请勿重复操作");
    private final String code;

    private final String msg;


    RetCodeEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }


    public String msg() {
        return this.msg;
    }

    public static RetCodeEnum getEnumByCode(String code) {
        for (RetCodeEnum retCodeEnum : RetCodeEnum.values()) {
            if (retCodeEnum.code == code) {
                return retCodeEnum;
            }
        }
        return null;
    }


    public String getCode() {
        return code;
    }


    public String getMsg() {
        return msg;
    }
}
