package com.ella.user.dto;

import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel("昵称配置")
@Data
public class NicknameCfgDto implements Serializable {

	private static final long serialVersionUID = 8899166223574214954L;

	@ApiModelProperty("自增ID")
	private Long id;

	@ApiModelProperty("英文昵称")
	private String eName;

	@ApiModelProperty("中文昵称")
	private String cName;

	@ApiModelProperty("性别（男:MALE  女:FEMALE）")
	private String gender;

	@ApiModelProperty("使用次数")
	private Long useNum;

	@ApiModelProperty("创建人")
	private String createBy;

	@ApiModelProperty("创建时间")
	private Date createTime;

	@ApiModelProperty("更新人")
	private String updateBy;

	@ApiModelProperty("更新时间")
	private Date updateTime;

	@ApiModelProperty("当前状态(NORMAL-正常,DELETE-删除)")
	private String status;
}
