package com.ella.user.dto;

import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("等级信息")
public class LexileLevelDto implements  Serializable{

	private static final long serialVersionUID = 1L;

	@ApiModelProperty("主键")
	private Integer id;

	@ApiModelProperty("等级编码LV1LV2")
	private String levelCode;

	@ApiModelProperty("等级别名(启蒙者)")
	private String levelName;

	@ApiModelProperty("序号")
	private Integer levelIndex;

	@ApiModelProperty("0:待确认1:修改中2:已确认")
	private Integer useStatus;

	@ApiModelProperty("听力")
	private String listen;

	@ApiModelProperty("词汇数")
	private Integer vocabularyNum;

	@ApiModelProperty("词汇描述")
	private String vocabularyDesc;

	@ApiModelProperty("句型数")
	private Integer grammarNum;

	@ApiModelProperty("语法描述")
	private String grammarDesc;

	@ApiModelProperty("拼读数")
	private Integer readingNum;

	@ApiModelProperty("阅读描述")
	private String readingDesc;

	@ApiModelProperty("写作")
	private Integer writingNum;

	@ApiModelProperty("写作描述")
	private String writingDesc;

	@ApiModelProperty("地图数量")
	private Integer mapNum;

	@ApiModelProperty("关卡数量")
	private Integer missionNum;

	@ApiModelProperty("课程数量")
	private Integer courseNum;

	@ApiModelProperty("绘本数量")
	private Integer pictureBookNum;

	@ApiModelProperty("阅读能力指数(起始区间)")
	private Integer readStartIndex;

	@ApiModelProperty("阅读能力指数(结束区间)")
	private Integer readEndIndex;

	@ApiModelProperty("等级目标")
	private String target;

	@ApiModelProperty("目标图片关联附件表")
	private String attachCode;

	@ApiModelProperty("等级内容介绍")
	private String introduction;

	@ApiModelProperty("等级能力介绍")
	private String levelAbilityDesc;

	@ApiModelProperty("最多可获得能量石数")
	private Integer maxStoneNum;

	@ApiModelProperty("创建时间")
	private Date createTime;

	@ApiModelProperty("修改时间")
	private Date updateTime;

	@ApiModelProperty("数据状态(NORMAL-正常,DELETE-删除)")
	private String status;

}
