package com.ella.user.dto;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@ApiModel("学习报告信息")
@EqualsAndHashCode
public class LearnReportDto implements Serializable{

	private static final long serialVersionUID = 218964747956197486L;
	
	@ApiModelProperty(notes="学习课程时间")
	private String learnTime;
	
	@ApiModelProperty(notes="完成课程数")
	private String learnCount;
	
	@ApiModelProperty(notes="跟读准确率")
	private String wordFollowAccuracyRate;
	
	@ApiModelProperty(notes="阅读绘本数")
	private String readBookCount;
	
	@ApiModelProperty(notes="查询词汇数")
	private String queryRecords;

	@ApiModelProperty(notes="测验准确率")
	private	String testAccuracyRate;
	
	@ApiModelProperty(notes="学习排名")
	private String learnRank;

}
