package com.ella.user.dto;

import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("新增反馈处理记录请求")
public class AddUserFeedbackHandleRecordRequest {

	@ApiModelProperty(value = "反馈记录ID", required = true)
	@NotNull
	private Long feedbackId;

	@ApiModelProperty(value = "处理后状态(WAIT_APPROVAL-未处理,RECEIVED-已接收，CONNECTING-联系中，RESOLVED-已解决)", required = true)
	@NotNull
	private String approvalStatus;

	@ApiModelProperty(value = "处理结果", required = true)
	@NotNull
	private String content;

	@ApiModelProperty(value = "处理人UID(前端无需上送，服务端自动获取登录管理员UID)", hidden = true)
	private String createBy;

	@ApiModelProperty(value = "处理人姓名(前端无需上送，服务端自动获取登录管理员姓名)", hidden = true)
	private String uname;
}
