package com.ella.user.dto;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("添加昵称配置请求参数")
public class AddNicknameCfgRequest implements Serializable {
	private static final long serialVersionUID = 313651778060681949L;

	@ApiModelProperty(value = "英文昵称", required = true)
	@NotNull
	private String eName;

	@ApiModelProperty(value = "中文昵称", required = true)
	@NotNull
	private String cName;

	@ApiModelProperty(value = "性别（男:MALE  女:FEMALE）", required = true)
	@NotNull
	private String gender;

	@ApiModelProperty(value = "操作人(前端传递无效，服务端自动获取登录用户)", hidden = true)
	private String createBy;

}
