package com.ella.user.api.learn;

import com.ella.frame.common.response.ResponseParams;
import com.ella.user.dto.learn.SaveFollowRecordRequest;
import com.ella.user.dto.learn.UserFollowRecordRequest;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Map;

/**
 * 用户跟读服务
 */
@FeignClient(value = "en-user-service")
public interface UserWordFollowService {

    /**
     * 保存跟读记录
     */
    @RequestMapping(path = "/v1/saveFollowRecord", method = RequestMethod.POST)
    ResponseParams<Boolean> saveFollowRecord(@RequestBody SaveFollowRecordRequest req);

    /**
     * 统计用户跟读信息
     *
     * @param uid         uid
     * @param mapCode     mapCode
     * @param missionCode missionCode
     * @return 统计结果
     */
    @RequestMapping(path = "/v1/countUserFollowRecord", method = RequestMethod.POST)
    Map<String, Integer> countUserFollowRecord(@RequestParam("uid") String uid, @RequestParam("mapCode") String mapCode,
                                               @RequestParam("missionCode") String missionCode, @RequestParam("learnTime") Integer learnTime);

    /**
     * 保存跟读记录,累计记录
     */
    @RequestMapping(path = "/v1/saveFollowRecordNew", method = RequestMethod.POST)
    Boolean saveFollowRecordNew(@RequestBody SaveFollowRecordRequest req);

    /**
     * 获取用户最近一次的单词跟读记录
     * @param req
     * @return
     */
    @RequestMapping(path = "/v1/getUserFollowRecord", method = RequestMethod.POST)
    ResponseParams getUserFollowRecord(UserFollowRecordRequest req);

    /**
     * 单词本保存跟读记录
     */
    @RequestMapping(path = "/v1/saveUserFollowRecord", method = RequestMethod.POST)
    ResponseParams<Boolean> saveUserFollowRecord(@RequestBody UserFollowRecordRequest req);
}
