package com.ella.user.api.enums;

/**
 * 评论类型枚举
 * 
 * @author maofengHan
 *
 */
public enum UserReviewTypeEnum {
	/**
	 * 文本
	 */
	TEXT("TEXT"),
	/**
	 * 语音
	 */
	VOICE("VOICE");

	private UserReviewTypeEnum(String code) {
		this.code = code;
	}

	private String code;

	public String getCode() {
		return code;
	}

	/**
	 * 根据状态字符串(code)获取Enum
	 * 
	 * @param code
	 * @return
	 */
	public static UserReviewTypeEnum forCode(String code) {
		for (UserReviewTypeEnum e : UserReviewTypeEnum.values()) {
			if (e.getCode().equals(code)) {
				return e;
			}
		}
		return null;
	}

	/**
	 * 是否包含指定状态
	 * 
	 * @param code
	 * @return
	 */
	public static boolean contains(String code) {
		return forCode(code) != null;
	}
}
