package com.ella.user.api.enums;

/**
 * 评论类型枚举
 * 
 * @author maofengHan
 *
 */
public enum UserReviewPerfectEnum {
	/**
	 * 文本
	 */
	YES("Y"),
	/**
	 * 语音
	 */
	NO("N");

	private UserReviewPerfectEnum(String code) {
		this.code = code;
	}

	private String code;

	public String getCode() {
		return code;
	}

	/**
	 * 根据状态字符串(code)获取Enum
	 * 
	 * @param code
	 * @return
	 */
	public static UserReviewPerfectEnum forCode(String code) {
		for (UserReviewPerfectEnum e : UserReviewPerfectEnum.values()) {
			if (e.getCode().equals(code)) {
				return e;
			}
		}
		return null;
	}

	/**
	 * 是否包含指定状态
	 * 
	 * @param code
	 * @return
	 */
	public static boolean contains(String code) {
		return forCode(code) != null;
	}
}
