package com.ella.user.api.enums;

/**
 * 用户评论审核状态枚举
 * 
 * @author maofengHan
 *
 */
public enum UserReviewApprovalStatusEnum {
	/**
	 * 未审批
	 */
	WAIT_APPROVAL("WAIT_APPROVAL"),
	/**
	 * 审批通过
	 */
	APPROVAL_YES("APPROVAL_YES"),
	/**
	 * 审批拒绝
	 */
	APPROVAL_NO("APPROVAL_NO");

	private UserReviewApprovalStatusEnum(String code) {
		this.code = code;
	}

	private String code;

	public String getCode() {
		return code;
	}

	/**
	 * 根据状态字符串(code)获取Enum
	 * 
	 * @param code
	 * @return
	 */
	public static UserReviewApprovalStatusEnum forCode(String code) {
		for (UserReviewApprovalStatusEnum e : UserReviewApprovalStatusEnum.values()) {
			if (e.getCode().equals(code)) {
				return e;
			}
		}
		return null;
	}

	/**
	 * 是否包含指定状态
	 * 
	 * @param code
	 * @return
	 */
	public static boolean contains(String code) {
		return forCode(code) != null;
	}
}
