package com.ella.user.api.enums;

/**
 * 用户反馈处理状态枚举
 * 
 * @author maofengHan
 *
 */
public enum UserFeedbackApprovalStatusEnum {
	/**
	 * 未处理
	 */
	WAIT_APPROVA("WAIT_APPROVA"),
	/**
	 * 已接收
	 */
	RECEIVED("RECEIVED"),
	/**
	 * 联系中
	 */
	CONNECTING("CONNECTING"),
	/**
	 * 已解决
	 */
	RESOLVED("RESOLVED");

	private UserFeedbackApprovalStatusEnum(String code) {
		this.code = code;
	}

	private String code;

	public String getCode() {
		return code;
	}

	/**
	 * 根据状态字符串(code)获取Enum
	 * 
	 * @param code
	 * @return
	 */
	public static UserFeedbackApprovalStatusEnum forCode(String code) {
		for (UserFeedbackApprovalStatusEnum e : UserFeedbackApprovalStatusEnum.values()) {
			if (e.getCode().equals(code)) {
				return e;
			}
		}
		return null;
	}

	/**
	 * 是否包含指定状态
	 * 
	 * @param code
	 * @return
	 */
	public static boolean contains(String code) {
		return forCode(code) != null;
	}
}
