package com.ella.user.api.enums;

/**
 * 
 * 查询文本类型
 *
 */
public enum QueryTextTypeEnum {
	/**
	 * 单词
	 */
	WORD("WORD"),
	/**
	 * 句子
	 */
	SENTENCE("SENTENCE");

	private QueryTextTypeEnum(String code) {
		this.code = code;
	}

	private String code;

	public String getCode() {
		return code;
	}

	/**
	 * 根据状态字符串(code)获取Enum
	 * 
	 * @param code
	 * @return
	 */
	public static QueryTextTypeEnum forCode(String code) {
		for (QueryTextTypeEnum e : QueryTextTypeEnum.values()) {
			if (e.getCode().equals(code)) {
				return e;
			}
		}
		return null;
	}

	/**
	 * 是否包含指定状态
	 * 
	 * @param code
	 * @return
	 */
	public static boolean contains(String code) {
		return forCode(code) != null;
	}
}
