package com.ella.user.api.enums;

/**
 * 数据状态枚举
 * 
 * @author maofengHan
 *
 */
public enum DataStatusEnum {
	/**
	 * 正常
	 */
	NORMAL("NORMAL"),
	/**
	 * 删除
	 */
	DELETE("DELETE"),
	/**
	 * 异常（不可用）
	 */
	EXCEPTION("EXCEPTION");

	private DataStatusEnum(String code) {
		this.code = code;
	}

	private String code;

	public String getCode() {
		return code;
	}

	/**
	 * 根据状态字符串(code)获取Enum
	 * 
	 * @param code
	 * @return
	 */
	public static DataStatusEnum forCode(String code) {
		for (DataStatusEnum e : DataStatusEnum.values()) {
			if (e.getCode().equals(code)) {
				return e;
			}
		}
		return null;
	}

	/**
	 * 是否包含指定状态
	 * 
	 * @param code
	 * @return
	 */
	public static boolean contains(String code) {
		return forCode(code) != null;
	}
}
