package com.ella.user.api.account;

import com.ella.frame.common.response.ResponseParams;
import com.ella.user.dto.account.AccountDto;
import com.ella.user.dto.account.EventTypeEnum;
import com.ella.user.dto.account.ModifyUserEllaCoinRequest;
import com.ella.user.dto.account.ModifyUserStoneRequest;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 用户财产账户相关服务
 */
@FeignClient("en-user-service")
public interface UserAccountService {

    /**
     * 用户咿啦币加减服务
     */
    @RequestMapping(value = "/v1/userAccount/modifyUserEllaCoin", method = RequestMethod.POST)
    ResponseParams<Boolean> modifyUserEllaCoin(@RequestBody ModifyUserEllaCoinRequest req);

    /**
     * 用户能量石加减服务
     */
    @RequestMapping(value = "/v1/userAccount/modifyUserStone", method = RequestMethod.POST)
    ResponseParams<Boolean> modifyUserStone(@RequestBody ModifyUserStoneRequest req);

    /**
     * 检查能量石消费记录是否已存在
     *
     * @param uid        用户UID
     * @param eventType  消费类型
     * @param relationId 关联ID
     * @return
     */
    @RequestMapping(value = "/v1/userAccount/checkStoneHasConsumed", method = RequestMethod.GET)
    ResponseParams<Boolean> checkStoneHasConsumed(@RequestParam(value = "uid", required = true) String uid,
                                                  @RequestParam(value = "eventType", required = true) EventTypeEnum eventType,
                                                  @RequestParam(value = "relationId", required = true) String relationId);

    /**
     * 查询用户账户余额
     */
    @RequestMapping(value = "/v1/userAccount/queryUserEllaCoin", method = RequestMethod.POST)
    AccountDto queryUserEllaCoin(@RequestParam(value = "uid", required = true) String uid);

    /**
     * 更新用户会员信息
     *
     * @param userId 用户uid
     * @param day    会员时长
     * @return {@link Boolean}
     */
    @RequestMapping(value = "/v1/userAccount/updateUserVipInfo", method = RequestMethod.POST)
    Boolean updateUserVipInfo(@RequestParam("userId") String userId, @RequestParam("day") int day);
}
