package com.ella.user.api;

import com.ella.user.dto.*;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ella.frame.common.response.ResponseParams;
import com.github.pagehelper.PageInfo;

/**
 * 用户反馈相关接口
 * 
 * @author maofengHan
 *
 */
@FeignClient("en-user-service")
public interface UserReviewService {

	/**
	 * 查询用户评论记录
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/v1/user-review/list", method = RequestMethod.POST)
	ResponseParams<PageInfo<UserReviewDto>> listUserReview(ListUserReviewRequest request);

	/**
	 * 添加用户评论
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/v1/user-review/add", method = RequestMethod.POST)
	ResponseParams<Boolean> addUserReview(AddUserReviewRequest request);

	/**
	 * 更新用户评论
	 * <p>
	 * 可更新-审批状态，数据状态，是否精彩评论）
	 * </p>
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/v1/user-review/update", method = RequestMethod.POST)
	ResponseParams<UserReviewDto> updateUserReview(UpdateUserReviewRequest request);

	/**
	 * APP用户评论列表
	 * <p>
	 *     通过绘本id查询该绘本的评论
	 * </p>
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "v1/user-review/applist",method = RequestMethod.POST)
	ResponseParams applistUserReview(ApplistUserReviewRequest request);
}
