package com.ella.user.api;

import java.util.List;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.ella.frame.common.response.ResponseParams;
import com.ella.user.dto.role.AddRoleRequest;
import com.ella.user.dto.role.EditRoleRequest;
import com.ella.user.dto.role.RoleDto;

@FeignClient("en-user-service")
public interface RoleService {
	/**
	 * 查询所有状态正常的角色信息
	 * 
	 * @return
	 */
	@RequestMapping(value = "/v1/role/all", method = RequestMethod.GET)
	ResponseParams<List<RoleDto>> all();

	/**
	 * 查询所有状态正常的角色信息
	 * 
	 * @return
	 */
	@RequestMapping(value = "/v1/role/delete", method = RequestMethod.GET)
	ResponseParams<Boolean> delete(@RequestParam(value = "roleCode", required = true) String roleCode,
			@RequestParam(value = "uid", required = true) String uid);

	/**
	 * 新增角色信息
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/v1/role/add", method = RequestMethod.POST)
	ResponseParams<Boolean> add(@RequestBody AddRoleRequest request);

	/**
	 * 编辑角色信息
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/v1/role/edit", method = RequestMethod.POST)
	ResponseParams<Boolean> edit(@RequestBody EditRoleRequest request);
}
