package com.ella.user.api;

import java.util.List;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.ella.frame.common.response.ResponseParams;
import com.ella.user.dto.menu.MenuDto;

@FeignClient("en-user-service")
public interface MenuService {

	/**
	 * 查询所有菜单
	 * 
	 * @return
	 */
	@RequestMapping(value = "/v1/menu/all", method = RequestMethod.GET)
	ResponseParams<List<MenuDto>> getAllEnable();

	/**
	 * 查询所有菜单，并标记角色已有的菜单
	 * 
	 * @return
	 */
	@RequestMapping(value = "/v1/menu/all-by-role", method = RequestMethod.GET)
	ResponseParams<List<MenuDto>> allByRole(@RequestParam(value = "roleCode", required = true) String roleCode);

	/**
	 * 查询角色下对应的菜单
	 * 
	 * @return
	 */
	@RequestMapping(value = "/v1/menu/by-role", method = RequestMethod.GET)
	ResponseParams<List<MenuDto>> menusByRole(@RequestParam(value = "roleCode", required = true) String roleCode);

	/**
	 * 查询角色下对应的菜单
	 * 
	 * @return
	 */
	@RequestMapping(value = "/v1/menu/by-uid", method = RequestMethod.GET)
	ResponseParams<List<MenuDto>> menusByUid(@RequestParam(value = "uid", required = true) String uid);
}
