package com.ella.user.api;

import java.util.List;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ella.frame.common.response.ResponseParams;
import com.ella.user.dto.LexileLevelHistoryDto;
import com.ella.user.dto.request.lexile.LexileEvaluationRequest;
import com.ella.user.dto.request.lexile.LexileLevelRequest;

/**
 * @author zhaojl
 *	用户蓝思评测历史查询
 */
@FeignClient("en-user-service")
public interface LexileLevelHistoryService {

	/**
	 * 查询蓝思评测历史列表->zhaojl
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/v1/lexileEvaluation/getLexileEvalHistoryList", method = RequestMethod.POST)
	ResponseParams<List<LexileLevelHistoryDto>> getLexileEvalHistoryList(LexileEvaluationRequest request);

	/**
	 * 查询当前蓝思评测信息->zhaojl
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/v1/lexileEvaluation/getLexileEvalHistoryDetail", method = RequestMethod.POST)
	ResponseParams<LexileLevelHistoryDto> getLexileEvalHistoryDetail(LexileEvaluationRequest request);

	/**
	 * 查询指定蓝思评测信息->zhaojl
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "/v1/lexileEvaluation/getOneLexileEvalHistoryDetail", method = RequestMethod.POST)
	ResponseParams<LexileLevelHistoryDto> getOneLexileEvalHistoryDetail(LexileLevelRequest request);

}
