package com.ella.user.dto.user;

import com.ella.frame.common.util.HeadParamTl;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

@Data
@ApiModel("用户登陆入参")
public class UserLoginRequest extends HeadParamTl {

    @ApiModelProperty(notes = "手机号", required = true)
    @NotBlank(message = "手机号码空")
    private String customerName;

    @ApiModelProperty(notes = "密码", required = true)
    private String password;

    @ApiModelProperty(notes = "验证码验证类型（0：无验证码(密码登录) 1：有验证码(验证码登录)")
    private String loginVerificationType;

    @ApiModelProperty(notes = "验证码")
    private String checkCode;

}
