package com.ella.user.dto.user;

import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("用户列表数据类")
public class UserListDto implements Serializable {

	private static final long serialVersionUID = 654452952976245982L;
	
	@ApiModelProperty(value = "自增ID", hidden = true)
	private Integer id;

	@ApiModelProperty(value = "UID")
    private String uid;

	@ApiModelProperty(value = "手机")
    private String mobile;

	@ApiModelProperty(value = "email")
	private String email;

	@ApiModelProperty(value = "性别")
    private String gender;

	@ApiModelProperty(value = "名字")
    private String name;

	@ApiModelProperty(value = "英文名")
    private String enName;

	@ApiModelProperty(value = "年龄")
    private Integer age;
	
	@ApiModelProperty(value = "生日")
    private Date birthday;

	@ApiModelProperty(value = "等级")
    private String level;

	@ApiModelProperty(value = "蓝思等级")
    private String lexileLevel;

	@ApiModelProperty(value = "头像")
    private String avatar;

	@ApiModelProperty(value = "上次登录时间")
    private Date lastLoginTime;

	@ApiModelProperty(value = "状态")
    private String status;

	@ApiModelProperty(value = "创建时间（注册时间）")
    private Date createTime;

	@ApiModelProperty(value = "更新时间")
    private Date updateTime;
}
