package com.ella.user.dto.user;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 用户详情数据类，用于运营工具-用户列表-用户详情
 * 
 * @author maofengHan
 *
 */
@Data
@ApiModel("用户详情数据类")
public class UserDetailDto implements Serializable {

	private static final long serialVersionUID = -4494363399823175372L;

	@ApiModelProperty(value = "自增ID", hidden = true)
	private Integer id;

	@ApiModelProperty(value = "UID")
	private String uid;

	@ApiModelProperty(value = "手机")
	private String mobile;

	@ApiModelProperty(value = "头像")
	private String avatar;

	@ApiModelProperty(value = "上次登录时间")
	private Date lastLoginTime;

	@ApiModelProperty(value = "创建时间（注册时间）")
	private Date createTime;

	@ApiModelProperty(value = "英文名")
	private String enName;

	@ApiModelProperty(value = "生日")
	private Date birthday;

	@ApiModelProperty(value = "性别")
	private String gender;

	@ApiModelProperty(value = "等级")
	private String level;

	@ApiModelProperty(value = "名字")
	private String name;

	@ApiModelProperty(value = "年龄")
	private Integer age;

	@ApiModelProperty(value = "蓝思等级")
	private String lexileLevel;

	@ApiModelProperty(value = "状态")
	private String status;

	@ApiModelProperty(value = "更新时间")
	private Date updateTime;
	
	@ApiModelProperty(value = "注册渠道")
	private String channel;
	
	@ApiModelProperty(value = "第三方登录")
	private String thirdPartLogin;
	
	@ApiModelProperty(value = "最近登录设备")
	private String latestLoginDevice;

	@ApiModelProperty("安卓账户余额")
    private BigDecimal balance;

	@ApiModelProperty("IOS账户余额")
    private BigDecimal iosBalance;
	
	@ApiModelProperty("累计充值金额")
	private BigDecimal sumRecharge = BigDecimal.ZERO;

	@ApiModelProperty("累计消费金额")
	private BigDecimal sumCost = BigDecimal.ZERO;
	
	@ApiModelProperty(value = "最近购买商品名称")
	private String latestOrderGoodsName;
	
	@ApiModelProperty(value = "最近学习课程")
	private String latestCourseName;
	
	@ApiModelProperty("学习总时长")
	private Integer sumLearningTime;
	
	@ApiModelProperty("总单词数")
	private Integer wordCount;
}
