package com.ella.user.dto.user;

import com.ella.frame.common.util.HeadParamTl;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import java.io.Serializable;

/**
 * @author ZLN
 * @create 2018-07-23 14:09
 **/
@Data
@ApiModel("用户注册入参")
public class RegisterRequest extends HeadParamTl implements Serializable {

    @ApiModelProperty(notes = "手机号", required = true)
    @NotEmpty(message = "手机号为空")
    private String customerName;

    @ApiModelProperty(notes = "密码", required = true)
    private String password;

    private String registerVerificationType;

    @ApiModelProperty(notes = "验证码", required = true)
    private String checkCode;

    private String registerType;

    private Boolean  codeIsRequired = true;
}
