package com.ella.user.dto.request.userinfo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * @author zhaojl
 */
@Data
@ApiModel("查询用户信息入参")
@EqualsAndHashCode
public class FindUserByIdRequest implements Serializable {

    private static final long serialVersionUID = -2514893641662732816L;

    @ApiModelProperty(notes = "用户Id", required = true)
    private String uid;

    @ApiModelProperty(notes = "登录系统是否为IOS(0不是,1是)", required = true)
    private Integer isIos;

    public FindUserByIdRequest() {
    }

    public FindUserByIdRequest(String uid, Integer isIos) {
        this.uid = uid;
        this.isIos = isIos;
    }
}
