package com.ella.user.dto.menu;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("菜单数据")
public class MenuDto implements Comparable<MenuDto> {

	@ApiModelProperty("ID")
	private Long id;

	@ApiModelProperty("父菜单ID")
	private Long parentId;

	@ApiModelProperty("菜单级别（1/2）")
	private Integer level;

	@ApiModelProperty("菜单名称")
	private String name;

	@ApiModelProperty("代码")
	private String code;

	@ApiModelProperty("菜单URL")
	private String url;

	@ApiModelProperty("是否启用")
	private Boolean enable;

	@ApiModelProperty("次序")
	private Integer ordr;

	@ApiModelProperty("备注")
	private String remark;

	@ApiModelProperty("子菜单")
	private List<MenuDto> children;

	@ApiModelProperty("已选择-用于编辑角色权限时（0：未选，1：已选）")
	private Integer checked = 0;

	@Override
	public int compareTo(MenuDto arg0) {
		if (this.ordr == null) {
			return -1;
		}
		if (arg0 == null || arg0.getOrdr() == null) {
			return 1;
		}
		return this.ordr - arg0.ordr;
	}

}
