package com.ella.user.dto.learn;

import javax.validation.constraints.NotNull;

import org.hibernate.validator.constraints.NotEmpty;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("保存跟读记录入参")
public class SaveFollowRecordRequest {
	
	@ApiModelProperty(notes="跟读的内容",required=true)
	@NotEmpty
	private String content;
	
	@ApiModelProperty(notes="跟读类型 注：句子-SENTENCE 单词-WORD",required=true)
	@NotEmpty
	private String contentType;
	
	@ApiModelProperty(notes="跟读发音地址(注：oss地址)",required=true)
	@NotEmpty
	private String voiceUrl;
	
	@ApiModelProperty(notes="跟读时长",required=true)
	@NotNull
	private Integer followReadTime;
	
	@ApiModelProperty(notes="跟读评测星级 0-5",required=true)
	@NotNull
	private Integer testScore;
	
	@ApiModelProperty(notes="跟读评测分数（第三方分数）",required=true)
	@NotNull
	private Float detailScore;
	
	@ApiModelProperty(notes="用户UID",required=false)
	@NotEmpty
	private String uid;
	
	
	@ApiModelProperty(notes="关卡编码",required=true)
	@NotEmpty
	private String missionCode;
	
	@ApiModelProperty(notes="课程编码",required=true)
	@NotEmpty
	private String courseCode;
	
	@ApiModelProperty(notes="讯飞评测结果报文",required=true)
	@NotEmpty
	private String testResult;
	
	@ApiModelProperty(notes="跟读场景类型(COURSE-课堂模式,SELF_STUDY-自学模式)",required=true)
	@NotEmpty
	private String followType;

	private String mapCode;

	private String levelCode;
}
