package com.ella.user.dto.dictionary;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel("词典dto")
@Data
public class DictionaryDto {
	@ApiModelProperty("id")
	private Integer id;
	
	@ApiModelProperty("单词")
    private String word;
	
	@ApiModelProperty("首字母")
    private String initial;
	
	@ApiModelProperty("EXCEPTION:不可用 ,NORMAL:可用")
    private String status;
	
	@ApiModelProperty("汉语描述")
    private String wordDesc;
	
	@ApiModelProperty("美式发音")
    private String usPhonetic;
	
	@ApiModelProperty("美式发音地址")
    private String usSpeech;
	
	@ApiModelProperty("解释")
    private String explains;
	
	@ApiModelProperty("普通发音")
    private String phonetic;
	
	@ApiModelProperty("英式发音")
    private String ukPhonetic;
	
	@ApiModelProperty("英式发音地址")
    private String ukSpeech;
	
	@ApiModelProperty("创建时间")
    private Date createTime;
	
	@ApiModelProperty("修改时间")
    private Date updateTime;

	@ApiModelProperty("true-已收藏 false-未收藏")
	private Boolean isCollected;
}
