package com.ella.user.dto.dictionary;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("查词结果及用户发音信息")
public class DictionaryAndUserLearnDto implements Serializable{
	
	private static final long serialVersionUID = 2611451599424432927L;
	
	@ApiModelProperty("id")
	private Integer id;
	
	@ApiModelProperty("单词")
    private String word;
	
	@ApiModelProperty("首字母")
    private String initial;
	
	@ApiModelProperty("EXCEPTION:不可用 ,NORMAL:可用")
    private String status;
	
	@ApiModelProperty("汉语描述")
    private String wordDesc;
	
	@ApiModelProperty("美式发音")
    private String usPhonetic;
	
	@ApiModelProperty("美式发音地址")
    private String usSpeech;
	
	@ApiModelProperty("解释")
    private String explains;
	
	@ApiModelProperty("普通发音")
    private String phonetic;
	
	@ApiModelProperty("英式发音")
    private String ukPhonetic;
	
	@ApiModelProperty("英式发音地址")
    private String ukSpeech;
	
	@ApiModelProperty("跟读发音地址 注:该字段为空代表不存在跟读信息")
	private String followVoice;
}
