package com.ella.user.dto.account;


/**
 * 账户加减余额类型
 * */
public enum MoneyChangeTypeEnum {
	/**
	 * 加
	 */
	ADD("+", "增加"),
	MINUS("-", "消费")
    ;
	private final String code;

	private final String msg;


	MoneyChangeTypeEnum(String code, String msg) {
		this.code = code;
		this.msg = msg;
	}

	
	public String msg() {
		return this.msg;
	}

	 public static MoneyChangeTypeEnum getEnumByCode(String code) {
	        for (MoneyChangeTypeEnum retCodeEnum : MoneyChangeTypeEnum.values()) {
	            if (retCodeEnum.code == code) {
	                return retCodeEnum;
	            }
	        }
	        return null;
	    }


	public String getCode() {
		return code;
	}


	public String getMsg() {
		return msg;
	}
}
