package com.ella.user.dto.account;

import java.io.Serializable;
import java.math.BigDecimal;

import javax.validation.constraints.NotNull;

import org.hibernate.validator.constraints.NotEmpty;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("修改用户咿啦币余额")
public class ModifyUserEllaCoinRequest implements Serializable{
	
	private static final long serialVersionUID = -7221659089365253987L;
	
	
	@ApiModelProperty("用户uid")
	@NotEmpty
	private String uid;
	
	@ApiModelProperty("咿啦币金额")
	@NotNull
	private BigDecimal changeMoney;
	
	@ApiModelProperty("加减类型")
	@NotNull
	private MoneyChangeTypeEnum changeType; 
	
	@ApiModelProperty("使用对象。注：用于区分ios余额变动还是非ios")
	@NotNull
	private AccountTypeEnum applicableObject;
	
	@ApiModelProperty("时间戳，放重复处理")
	@NotNull
	private Long timex;
	
	@ApiModelProperty("订单编号，放重复处理")
	@NotEmpty
	private String orderNo;

}
