package com.ella.user.dto.account;


/**
 * 事件类型
 * */
public enum EventTypeEnum {
	/**
	 * 蓝思事件类型
	 */
	PASS_MISSION("PASS_MISSION", "闯关成功"),
	CHANGE("CHANGE", "矫正"),
	LEXILE_TEST("LEXILE_TEST", "蓝思评测");
	private final String code;

	private final String msg;


	EventTypeEnum(String code, String msg) {
		this.code = code;
		this.msg = msg;
	}

	
	public String msg() {
		return this.msg;
	}

	 public static EventTypeEnum getEnumByCode(String code) {
	        for (EventTypeEnum retCodeEnum : EventTypeEnum.values()) {
	            if (retCodeEnum.code == code) {
	                return retCodeEnum;
	            }
	        }
	        return null;
	    }


	public String getCode() {
		return code;
	}


	public String getMsg() {
		return msg;
	}
}
