package com.ella.user.dto;

import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("词汇查询信息")
public class WordQueryRecordDto implements Serializable {

	private static final long serialVersionUID = -4735460196567569771L;

	@ApiModelProperty(notes = "主键ID")
	private Integer id;

	@ApiModelProperty(notes = "单词")
	private String word;
	
	@ApiModelProperty(notes = "是否在单词墙")
	private boolean inWordWall;

	@ApiModelProperty(notes = "汉语描述")
	private String desc;

	@ApiModelProperty(notes = "等级")
	private String levelCode;

	@ApiModelProperty(notes = "地图code")
	private String mapCode;
	
	@ApiModelProperty(notes = "关卡code")
	private String missionCode;

	@ApiModelProperty(notes = "课程code")
	private String courseCode;

	@ApiModelProperty(notes = "用户uid")
	private String uid;

	@ApiModelProperty(notes = "EXCEPTION:不可用 ,NORMAL:可用")
	private String status;

	@ApiModelProperty(notes = "创建时间")
	private Date createTime;

	@ApiModelProperty(notes = "修改时间")
	private Date updateTime;
}
