package com.ella.user.dto;

import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("跟读信息")
public class WordFollowRecordDto implements Serializable {

	private static final long serialVersionUID = -8757261558481203633L;

	@ApiModelProperty(notes = "主键ID")
	private Integer id;

	@ApiModelProperty(notes = "单词")
	private String content;

	@ApiModelProperty(notes = "类型 句子 单词")
	private String contentType;

	@ApiModelProperty(notes = "等级")
	private String levelCode;

	@ApiModelProperty(notes = "地图code")
	private String mapCode;

	@ApiModelProperty(notes = "关卡code")
	private String missionCode;

	@ApiModelProperty(notes = "课程唯一编码")
	private String courseCode;

	@ApiModelProperty(notes = "用户ID")
	private String uid;

	@ApiModelProperty(notes = "发音地址")
	private String voiceUrl;

	@ApiModelProperty(notes = "跟读时长")
	private Integer followReadTime;

	@ApiModelProperty(notes = "跟读评测分数")
	private Integer testScore;
	
	@ApiModelProperty(notes = "EXCEPTION:不可用 ,NORMAL:可用")
	private String status;

	@ApiModelProperty(notes = "创建时间")
	private Date createTime;

	@ApiModelProperty(notes = "修改时间")
	private Date updateTime;

}
