package com.ella.user.dto;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 用户反馈处理记录
 * 
 * @author maofengHan
 *
 */
@Data
@ApiModel("用户反馈处理记录")
public class UserFeedbackHandleRecordDto {

	@ApiModelProperty("记录ID")
	private Long id;

	@ApiModelProperty("反馈记录ID")
	private Long feedbackId;

	@ApiModelProperty("处理人UID")
	private String createBy;

	@ApiModelProperty("处理人姓名")
	private String uname;

	@ApiModelProperty("处理后状态(WAIT_APPROVAL-未处理,RECEIVED-已接收，CONNECTING-联系中，RESOLVED-已解决)")
	private String approvalStatus;

	@ApiModelProperty("处理时间")
	private Date createTime;

	@ApiModelProperty("处理结果")
	private String content;
}
