package com.ella.user.dto;

import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("学习报告课程信息")
public class UserCourseDto implements Serializable {
	private static final long serialVersionUID = 8079524968308020228L;

	@ApiModelProperty(notes = "主键ID")
	private Integer id;

	@ApiModelProperty(notes = "用户ID")
	private String uid;
	
	@ApiModelProperty(notes = "关卡code")
	private String missionCode;

	@ApiModelProperty(notes = "地图code")
	private String mapCode;

	@ApiModelProperty(notes = "等级code")
	private String levelCode;

	@ApiModelProperty(notes = "课程唯一码")
	private String courseCode;
	
	@ApiModelProperty(notes = "课程名称")
	private String courseName;
	
	@ApiModelProperty(notes = "资源类型(目前类型都是课程)")
	private String resourceType;

	@ApiModelProperty(notes = "关联图书编号")
	private String bookCode;

	@ApiModelProperty(notes = "课程学习进度")
	private String process;

	@ApiModelProperty(notes = "学习累计时长")
	private Integer learnTime;

	@ApiModelProperty(notes = "已过关(PASS) 进行中(DOING) 未开始(NOTSTARTED)")
	private String status;

	@ApiModelProperty(notes = "创建时间")
	private Date createTime;

	@ApiModelProperty(notes = "修改时间")
	private Date updateTime;

}
