package com.ella.user.dto;

import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel("产品信息")
@Data
public class ProductDto implements Serializable{

	private static final long serialVersionUID = 7013619049407707087L;
	
	@ApiModelProperty("产品id")
	private Long id;

	@ApiModelProperty("产品（服务）名称")
    private String name;
	
	@ApiModelProperty("学科（1:英语 2:语文 3:数学）")
    private Long subjectType;
	
	@ApiModelProperty("授课类型（1:1vs1 2:1vs2 3:1vs3 4:1vs4 10:大会堂）")
    private Long teachingType;
	
	@ApiModelProperty("课程时长（单位：分钟）")
    private Long courseDuration;
	
	@ApiModelProperty("课程间隙时长（单位：分钟）")
    private Long intervalTime;
	
	@ApiModelProperty("每堂最低警示价（人民币，单位：分）")
    private Long perMinimumPrice;
	
	@ApiModelProperty("可提前订课时间（单位：分）")
    private Long advanceReserveTime;
	
	@ApiModelProperty("可提前取消时间（单位：分）")
    private Long advanceCancelTime;
	
	@ApiModelProperty("可提前进教室时间（单位：分）")
    private Long advanceEnterTime;
	
	@ApiModelProperty("产品状态（1:上架 2:下架 3:审核中 4:审核通过 5:审核拒绝）")
    private Long status;
	
	@ApiModelProperty("产品（服务）描述")
    private String description;
	
	@ApiModelProperty("状态（ 1: 有效 0: 无效）")
    private Byte isValid;
	
	@ApiModelProperty("创建人员id")
    private Long createId;
	
	@ApiModelProperty("创建时间")
    private Date createTime;
	
	@ApiModelProperty("修改人员id")
    private Long updateId;
	
	@ApiModelProperty("修改时间")
    private Date updateTime;
}
